%% PLOTTING C60 SENSOR'S FREQUENCY RESPONSE

%%
clc;
clear all;
close all;


%% Selecting file
list1 = {'out_frequency_NO_O_down.csv',...      % Vctrl = 18 V, Vref = 1 V
         'out_frequency_NO_N_down.csv',...      % Vctrl = 19 V, Vref = 1 V
         'out_frequency_NO_flat.csv',...        % Vctrl = 20 V, Vref = 1 V
         'out_frequency_NO2_O_down.csv',...     % Vctrl = 27 V, Vref = 1.7 V
         'out_frequency_NO2_N_down.csv',...     % Vctrl = 28 V, Vref = 1.7 V
         'out_frequency_NO2_flat.csv',...       % Vctrl = 29 V, Vref = 1.7 V
         };    

[indx1,tf1] = listdlg('ListString', list1,'SelectionMode','single',...
                      'PromptString','Select file');
file = list1{indx1};    % Selected file
 
 
%% Extracting data
importfile(file);
[raws,columns] = size(data);

t = 1;

for tt = 1:2:(columns/3)-1
    time(:,t) = data(:,tt);
    t = t + 1;
end

j = 1;

for i = 2:2:(columns/3)
    VCTRL(:,j) = data(:,i);
    IDS(:,j) = data(:,i+16);
    FOUT(:,j) = data(:,i+32);
    
    j = j + 1;
end


switch file
    case 'out_frequency_NO_O_down.csv'
        Vctrl_target = 18;
        label = {'NO (O down) vs Ar',...
                 'NO (O down) vs CO',...
                 'NO (O down) vs CO_{2}',...
                 'NO (O down) vs N_{2}',...
                 'NO (O down) vs H_{2}O (flat)',...
                 'NO (O down) vs H_{2}O (H down)',...
                 'NO (O down) vs H_{2}O (O down)',...
                 'NO (O down) vs O_{2}',...
                 };
        
    case 'out_frequency_NO_N_down.csv'
        Vctrl_target = 19;
        label = {'NO (N down) vs Ar',...
                 'NO (N down) vs CO',...
                 'NO (N down) vs CO_{2}',...
                 'NO (N down) vs N_{2}',...
                 'NO (N down) vs H_{2}O (flat)',...
                 'NO (N down) vs H_{2}O (H down)',...
                 'NO (N down) vs H_{2}O (O down)',...
                 'NO (N down) vs O_{2}',...
                 };

    case 'out_frequency_NO_flat.csv'
        Vctrl_target = 20;
        label = {'NO (flat) vs Ar',...
                 'NO (flat) vs CO',...
                 'NO (flat) vs CO_{2}',...
                 'NO (flat) vs N_{2}',...
                 'NO (flat) vs H_{2}O (flat)',...
                 'NO (flat) vs H_{2}O (H down)',...
                 'NO (flat) vs H_{2}O (O down)',...
                 'NO (flat) vs O_{2}',...
                 };

    case 'out_frequency_NO2_O_down.csv'
        Vctrl_target = 27;
        label = {'NO_{2} (O down) vs Ar',...
                 'NO_{2} (O down) vs CO',...
                 'NO_{2} (O down) vs CO_{2}',...
                 'NO_{2} (O down) vs N_{2}',...
                 'NO_{2} (O down) vs H_{2}O (flat)',...
                 'NO_{2} (O down) vs H_{2}O (H down)',...
                 'NO_{2} (O down) vs H_{2}O (O down)',...
                 'NO_{2} (O down) vs O_{2}',...
                 };
    
    case 'out_frequency_NO2_N_down.csv'
        Vctrl_target = 28;
        label = {'NO_{2} (N down) vs Ar',...
                 'NO_{2} (N down) vs CO',...
                 'NO_{2} (N down) vs CO_{2}',...
                 'NO_{2} (N down) vs N_{2}',...
                 'NO_{2} (N down) vs H_{2}O (flat)',...
                 'NO_{2} (N down) vs H_{2}O (H down)',...
                 'NO_{2} (N down) vs H_{2}O (O down)',...
                 'NO_{2} (N down) vs O_{2}',...
                 };

    case 'out_frequency_NO2_flat.csv'
        Vctrl_target = 29;
        label = {'NO_{2} (flat) vs Ar',...
                 'NO_{2} (flat) vs CO',...
                 'NO_{2} (flat) vs CO_{2}',...
                 'NO_{2} (flat) vs N_{2}',...
                 'NO_{2} (flat) vs H_{2}O (flat)',...
                 'NO_{2} (flat) vs H_{2}O (H down)',...
                 'NO_{2} (flat) vs H_{2}O (O down)',...
                 'NO_{2} (flat) vs O_{2}',...
                 };

end


Vctrl_atm = [3:1:10];           % Vctrl of atmospheric gas

k = 1;

time_ns = time*1e9;

for k = 1:length(label)    
    %% VCTRL
    figure(k+2);
    subplot(3,1,1);
    p1 = plot(time(:,k)*1e9,VCTRL(:,k),...                  
         'DisplayName',char(label(k)),...
         'Color','g','LineWidth',1.5);
    %             pbaspect([1 1 1]);
    xlabel('Time [ns]');
    ylabel('V_{CTRL} [V]');
    xticklabels({'0','25','50','75'})
    xticks([0 25 50 75])
    yticklabels({num2str(Vctrl_atm(k)),num2str(Vctrl_target)})
    yticks([Vctrl_atm(k) Vctrl_target])
    xlim([0 75]);
    ylim([0 30]);
    hold on;
    grid on;
    title(label(k));
%     legend('Location','northeast');
    
    
    %% IDS
    % figure(2);
    subplot(3,1,2);
    p2 = plot(time(:,k)*1e9,IDS(:,k)*1e6,...          % in uA                
         'DisplayName',char(label(k)),...
         'Color','r','LineWidth',1.5);
    %             pbaspect([1 1 1]);
    xlabel('Time [ns]');
    ylabel('I_{DS} [\muA]');
    xticklabels({'0','25','50','75'});
    xticks([0 25 50 75]);
    
    xlim([0 75]);
%     ylim([10 40]);    
    hold on;
    grid on;
%     legend('Location','northeast');
    
    
    %% FOUT
    % figure(3);
    subplot(3,1,3);
    p3 = plot(time(:,k)*1e9,FOUT(:,k)*1e-6,...          % in MHz                
         'DisplayName',char(label(k)),...
         'Color','b','LineWidth',1.5);
    %             pbaspect([1 1 1]);
    xlabel('Time [ns]');
    ylabel('f_{out} [MHz]');
    xticklabels({'0','25','50','75'});
    xticks([0 25 50 75]);
    
    xlim([0 75]);
%     ylim([0 600]);
    hold on;
    grid on;
%     legend('Location','east');

%     % Puntual extraction
%     a = round(length(time_ns(:,k))/6);
%     b = round(length(time_ns(:,k))/2);
%     c = round(length(time_ns(:,k))*5/6);
% 
%     datatip(p2,'DataIndex',a);
%     datatip(p2,'DataIndex',b);
%     datatip(p2,'DataIndex',c);
% 
%     datatip(p3,'DataIndex',a);
%     datatip(p3,'DataIndex',b);
%     datatip(p3,'DataIndex',c);


end


I_F_meas = zeros(length(label),4);
r = 1;

for k = 1:length(label)
    %% Calculation of average values of currents
    IDS_meas = IDS(:,k);
    j_i0 = find(IDS(:,k)==0);
    
    IDS_meas(j_i0) = [];
    IDS_meas(isnan(IDS_meas)) = [];
    
    diff_IDS_meas = [0; diff(IDS_meas)];
    
    [max_i_diff,j_IDS_edges] = maxk(abs(diff_IDS_meas),2);

    j_IDS_edges = sort(j_IDS_edges);
    
    IDS_atm_1 = IDS_meas(1:j_IDS_edges(1)-1);
    IDS_atm_3 = IDS_meas(j_IDS_edges(2):end);

    IDS_atm = [IDS_atm_1;...
               IDS_atm_3];

    IDS_target = [IDS_meas(j_IDS_edges(1):...
                             (j_IDS_edges(2)-1))];
    

    % Average and standard deviation of currents
    IDS_atm_1_avg = mean(IDS_atm_1)*1e6         % [uA]
    IDS_atm_1_std = std(IDS_atm_1)*1e6;          % [uA]
    
    IDS_target_avg = mean(IDS_target)*1e6   % [uA]
    IDS_target_std = std(IDS_target)*1e6;    % [uA]

    IDS_atm_3_avg = mean(IDS_atm_3)*1e6         % [uA]
    IDS_atm_3_std = std(IDS_atm_3)*1e6;          % [uA]

    IDS_atm_avg = mean(IDS_atm)*1e6;         % [uA]
    IDS_atm_std = std(IDS_atm)*1e6;          % [uA]

    


    %% Calculation of average values of frequencies
    FOUT_meas = FOUT(:,k);
    j_f0 = find(FOUT(:,k)==0);
    
    FOUT_meas(j_f0) = [];
    FOUT_meas(isnan(FOUT_meas)) = [];
    
    diff_FOUT_meas = [0; diff(FOUT_meas)];
    
    [max_f_diff,j_FOUT_edges] = maxk(abs(diff_FOUT_meas),2);

    j_FOUT_edges = sort(j_FOUT_edges);
    
    FOUT_atm_1 = FOUT_meas(1:j_FOUT_edges(1)-1);
    FOUT_atm_3 = FOUT_meas(j_FOUT_edges(2):end);

    FOUT_atm = [FOUT_atm_1;...
                FOUT_atm_3];

    FOUT_target = [FOUT_meas(j_FOUT_edges(1):...
                             (j_FOUT_edges(2)-1))];
    
    % Average and standard deviation of frequencies
    FOUT_atm_1_avg = mean(FOUT_atm_1)*1e-6      % [MHz]
    FOUT_atm_1_std = std(FOUT_atm_1)*1e-6;       % [MHz]
    
    FOUT_target_avg = mean(FOUT_target)*1e-6      % [MHz]      
    FOUT_target_std = std(FOUT_target)*1e-6;       % [MHz]

    FOUT_atm_3_avg = mean(FOUT_atm_3)*1e-6      % [MHz]
    FOUT_atm_3_std = std(FOUT_atm_3)*1e-6;       % [MHz]

    FOUT_atm_avg = mean(FOUT_atm)*1e-6      % [MHz]
    FOUT_atm_std = std(FOUT_atm)*1e-6;       % [MHz]

    

    % Table of results
    I_F_meas(r,:) = [IDS_target_avg, IDS_atm_avg,...
                     FOUT_target_avg, FOUT_atm_avg];

    r = r + 1;
    
    %% Writing data on Excel
    write_NO = 'NO_simul.xlsx';
    write_NO2 = 'NO2_simul.xlsx';
    
    IDS_w = I_F_meas([1:8],[1:2]);
    FOUT_w = I_F_meas([1:8],[3:4]);
    
    switch file
        case 'out_frequency_NO_O_down.csv'
            writematrix(IDS_w,write_NO,'Sheet',1,'Range','C3:D10');
            writematrix(FOUT_w,write_NO,'Sheet',1,'Range','F3:G10');

        case 'out_frequency_NO_N_down.csv'
            writematrix(IDS_w,write_NO,'Sheet',2,'Range','C3:D10');
            writematrix(FOUT_w,write_NO,'Sheet',2,'Range','F3:G10');

        case 'out_frequency_NO_flat.csv'
            writematrix(IDS_w,write_NO,'Sheet',3,'Range','C3:D10');
            writematrix(FOUT_w,write_NO,'Sheet',3,'Range','F3:G10');
    
        case 'out_frequency_NO2_O_down.csv'
            writematrix(IDS_w,write_NO2,'Sheet',1,'Range','C3:D10');
            writematrix(FOUT_w,write_NO2,'Sheet',1,'Range','F3:G10');
        
        case 'out_frequency_NO2_N_down.csv'
            writematrix(IDS_w,write_NO2,'Sheet',2,'Range','C3:D10');
            writematrix(FOUT_w,write_NO2,'Sheet',2,'Range','F3:G10');
    
        case 'out_frequency_NO2_flat.csv'
            writematrix(IDS_w,write_NO2,'Sheet',3,'Range','C3:D10');
            writematrix(FOUT_w,write_NO2,'Sheet',3,'Range','F3:G10');
    
    end

end






